using System;
using gov.va.med.vbecs.GUI.controls;
using System.Threading;
using gov.va.med.vbecs.Lock;

namespace gov.va.med.vbecs.admin.GUI.Lock
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/18/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// VBECS Administrator application startup lock class. Ensures that only one instace of 
	/// the VBECS Administrator can run at the server at a moment of time.
	/// </summary>

	#endregion

	public class VbecsAdminAppStartupLock : SyncLockBase
	{
		/// <summary>
		/// Global VBECS Administrator application synchronization token (mutex name).
		/// Used to indicate that VBECS Administrator application is running on the server. 
		/// </summary>
		protected const string GlobalAdminSyncToken = @"Global\gov.va.med.vbecs.GlobalAdminSyncToken";

        private SharedMutex _adminGlobalMutex;

		/// <summary>
		/// Creates new lock and checks if there's an existing lock.
		/// </summary>
		public VbecsAdminAppStartupLock() : base() {}

		/// <summary>
		/// Obtains new lock and checks for existing lock. 
		/// </summary>
		protected override void ObtainAppSpecificGlobalLocks()
		{
            bool adminIsNotRunningOnServer;
            _adminGlobalMutex = new SharedMutex(GlobalAdminSyncToken, out adminIsNotRunningOnServer);
            if (!adminIsNotRunningOnServer)
                throw new AppLockingException(Common.StrRes.SysErrMsg.MUC01.AnotherInstanceOfVbecsAdminIsRunning());
		}

		/// <summary>
		/// Releases the lock. 
		/// </summary>
		protected override void ReleaseAppSpecificGlobalLocks()
		{
            if (_adminGlobalMutex != null)
			    _adminGlobalMutex.Dispose();
		}

	}
}
